   canvas=new Object;
   canvas.scale=1.0; // zoom scaling
   canvas.scaleFont=0.8; // font scaling
   canvas.scaleLine=1.3; // line scaling
   canvas.pxPerCm=35; // px per cm
   canvas.frameWidth=18.0; // cm
   canvas.frameHeight=13.5; // cm
   plotOptions=new Object;
   plotOptions.plotPosX=3.0; // cm
   plotOptions.plotPosY=1.5;  // cm
   plotOptions.plotWidth=11.5; // cm
   plotOptions.plotHeight=11.5; // cm
   plotOptions.minx=0;
   plotOptions.maxx=1;
   plotOptions.miny=-6;
   plotOptions.maxy=6;
   plotOptions.xlabel="Proportion";
   plotOptions.ylabel="Standard Deviations";
   plotOptions.title="Known Age";
   plotOptions.data=new Array;
   plotOptions.data[0]=new Object;
   plotOptions.data[0].name="theory";
   plotOptions.data[0].line="solid";
   plotOptions.data[0].marker="";
   plotOptions.data[0].x=[0.01, 0.02, 0.03, 0.04, 0.05, 0.06, 0.07, 0.08, 0.09, 0.1, 0.11, 0.12, 0.13, 0.14, 0.15, 0.16, 0.17, 0.18, 0.19, 0.2, 0.21, 0.22, 0.23, 0.24, 0.25, 0.26, 0.27, 0.28, 0.29, 0.3, 0.31, 0.32, 0.33, 0.34, 0.35, 0.36, 0.37, 0.38, 0.39, 0.4, 0.41, 0.42, 0.43, 0.44, 0.45, 0.46, 0.47, 0.48, 0.49, 0.5, 0.51, 0.52, 0.53, 0.54, 0.55, 0.56, 0.57, 0.58, 0.59, 0.6, 0.61, 0.62, 0.63, 0.64, 0.65, 0.66, 0.67, 0.68, 0.69, 0.7, 0.71, 0.72, 0.73, 0.74, 0.75, 0.76, 0.77, 0.78, 0.79, 0.8, 0.81, 0.82, 0.83, 0.84, 0.85, 0.86, 0.87, 0.88, 0.89, 0.9, 0.91, 0.92, 0.93, 0.94, 0.95, 0.96, 0.97, 0.98, 0.99];
   plotOptions.data[0].y=[-2.33, -2.05, -1.88, -1.75, -1.64, -1.55, -1.48, -1.41, -1.34, -1.28, -1.23, -1.17, -1.13, -1.08, -1.04, -0.99, -0.95, -0.92, -0.88, -0.84, -0.81, -0.77, -0.74, -0.71, -0.67, -0.64, -0.61, -0.58, -0.55, -0.52, -0.50, -0.47, -0.44, -0.41, -0.39, -0.36, -0.33, -0.31, -0.28, -0.25, -0.23, -0.20, -0.18, -0.15, -0.13, -0.10, -0.08, -0.05, -0.03, 0.00, 0.03, 0.05, 0.08, 0.10, 0.13, 0.15, 0.18, 0.20, 0.23, 0.25, 0.28, 0.31, 0.33, 0.36, 0.39, 0.41, 0.44, 0.47, 0.50, 0.52, 0.55, 0.58, 0.61, 0.64, 0.67, 0.71, 0.74, 0.77, 0.81, 0.84, 0.88, 0.92, 0.95, 0.99, 1.04, 1.08, 1.13, 1.17, 1.23, 1.28, 1.34, 1.41, 1.48, 1.55, 1.64, 1.75, 1.88, 2.05, 2.33];
   


  function tidyText(str)
  {
   return str.replace(/\x2b\x2f\x2d/g,String.fromCharCode(0x00b1));
  };


  ViewPort.prototype.xy_data=function(dt)
  {
   var i;
   if(dt.line)
   {
    this.appendChild(this.polyline(dt.name,dt.x,dt.y,dt.line));
   };
   if(dt.dx)
   {
    if(dt.dy)
    {
     for(i=0;i<dt.x.length;i++)
     {
      this.appendChild(this.errorbars(dt.x[i],dt.y[i],dt.dx[i],dt.dy[i],0));
     };
    }
    else
    {
     for(i=0;i<dt.x.length;i++)
     {
      this.appendChild(this.errorbars(dt.x[i],dt.y[i],dt.dx[i],0,0));
     };
    };
   }
   else
   {
    if(dt.dy)
    {
     for(i=0;i<dt.x.length;i++)
     {
      this.appendChild(this.errorbars(dt.x[i],dt.y[i],0,dt.dy[i],0));
     };
    };
   };
   if(dt.marker)
   {
    for(i=0;i<dt.x.length;i++)
    {
     this.appendChild(this.symbol(dt.x[i],dt.y[i],0,dt.marker));
    };
   };
  };

  function checkMin(dt,type,m)
  {
   var i,v;
   if(!dt[type]){return 0;};
   if(dt["d"+type])
   {
    if(m=="auto"){m=dt[type][0]-dt["d"+type][0];};
    for(i=0;i<dt[type].length;i++)
    {
     if(m>dt[type][i]-dt["d"+type][i])
     {
      m=dt[type][i]-dt["d"+type][i];
     };
    };
   }
   else
   {
    if(m=="auto"){m=dt[type][0];};
    for(i=0;i<dt[type].length;i++)
    {
     if(m>dt[type][i])
     {
      m=dt[type][i];
     };
    };
   };
   return m;
  };

  function checkMax(dt,type,m)
  {
   var i,v;
   if(!dt[type]){return 0;};
   if(dt["d"+type])
   {
    if(m=="auto"){m=dt[type][0]+dt["d"+type][0];};
    for(i=0;i<dt[type].length;i++)
    {
     if(m<dt[type][i]+dt["d"+type][i])
     {
      m=dt[type][i]+dt["d"+type][i];
     };
    };
   }
   else
   {
    if(m=="auto"){m=dt[type][0];};
    for(i=0;i<dt[type].length;i++)
    {
     if(m<dt[type][i])
     {
      m=dt[type][i];
     };
    };
   };
   return m;
  };

  ViewPort.prototype.xy_plot=function(pd)
  {
    var plotarea,i;
    //check axes
    if(pd.minx=="auto"){for(i=0;i<pd.data.length;i++){pd.minx=checkMin(pd.data[i],"x",pd.minx);};};
    if(pd.maxx=="auto"){for(i=0;i<pd.data.length;i++){pd.maxx=checkMax(pd.data[i],"x",pd.maxx);};};
    if(pd.miny=="auto"){for(i=0;i<pd.data.length;i++){pd.miny=checkMin(pd.data[i],"y",pd.miny);};};
    if(pd.maxy=="auto"){for(i=0;i<pd.data.length;i++){pd.maxy=checkMax(pd.data[i],"y",pd.maxy);};};
    
    // define area of plot
    
	plotarea=this.viewPort("plotarea",pd.plotPosX,pd.plotPosY,
	 pd.plotWidth,pd.plotHeight);
	plotarea.map(0,0,1,1);
	plotarea.clipPath(plotarea.rectangle(0,0,1,1,""));
	plotarea.map(pd.minx,pd.miny,pd.maxx-pd.minx,pd.maxy-pd.miny);
	for(i=0;i<pd.data.length;i++)
	{
	 plotarea.xy_data(pd.data[i]);
	};

	// put all of the elements on the plot
    this.map(0,0,this.canvas.frameWidth,this.canvas.frameHeight);
	this.appendChild(plotarea.element);
	this.appendChild(this.rectangle(pd.plotPosX,pd.plotPosY,
	  pd.plotWidth,pd.plotHeight,"border"));
	this.xlabel=pd.xlabel;
	this.ylabel=pd.ylabel;
  	this.mapRectangle(pd.plotPosX,pd.plotPosY,
  	  pd.plotWidth,pd.plotHeight,
  	  pd.minx,0,pd.maxx-pd.minx,pd.plotHeight);
	this.axis("x",pd.minx,pd.maxx);
    this.map(0,0,this.canvas.frameWidth,this.canvas.frameHeight);
  	this.mapRectangle(pd.plotPosX,pd.plotPosY,
  	  pd.plotWidth,pd.plotHeight,
  	  0,pd.miny,pd.plotWidth,pd.maxy-pd.miny);
	this.axis("y",pd.miny,pd.maxy);
    this.map(0,0,this.canvas.frameWidth,this.canvas.frameHeight);
  	this.mapRectangle(pd.plotPosX,pd.plotPosY,
  	  pd.plotWidth,pd.plotHeight,
  	  0,0,1,1);
	this.appendChild(this.text(0.5,0.98,tidyText(pd.title),12,"middle",-1.25));
  
  };

  function draw(canv)
  {
    var mainViewport,plotarea;
    var mainFrame;
    // link plot to SVG document
    mainFrame=attachSVGDocument(canv.frameWidth,canv.frameHeight,canv.scale,canv.scaleFont,canv.scaleLine);
	mainFrame.map(0,0,canv.frameWidth,canv.frameHeight);
   
	// set up main viewport
	mainViewport=mainFrame.viewPort("mainviewport",0,0,canv.frameWidth,canv.frameHeight);
    mainViewport.map(0,0,canv.frameWidth,canv.frameHeight);
    mainViewport.canvas=canv;
    mainFrame.appendChild(mainViewport.element);
    
    // put on the plot
    mainViewport.xy_plot(plotOptions);
  };