data={"parameters":[{"parameter":"batch","label":"Batch","type":"Text","units":"","options":[],"description":"Analysis batch for laboratory measurements."},{"parameter":"by","label":"By","type":"Text","units":"","options":[],"description":"The person or organisation responsible for a particular data compilation or publication."},{"parameter":"calage","label":"CalAge","type":"Number","units":"years","description":"The known age of a sample in calBP (used in IntCal projects).","options":[]},{"parameter":"calage_range","label":"CalSpan","type":"Number","units":"years","description":"The age range of a known age sample (used in IntCal projects).  A single year sample would have a value of 1, a five year block of tree rings would be 5.","options":[]},{"parameter":"calage_sigmaC","label":"±1σ_{C}","type":"Number","units":"years","description":"The correlated component of the uncertainty in calage (used in IntCal projects).","options":[]},{"parameter":"calage_sigmaD","label":"±1σ_{D}","type":"Number","units":"years","description":"The systematic uncertainty in calage (used in IntCal projects).","options":[]},{"parameter":"calage_sigmaI","label":"±1σ_{I}","type":"Number","units":"years","description":"The independent uncertainty in calage (used in IntCal projects).","options":[]},{"parameter":"changed","label":"Changed","type":"Boolean","units":"","options":[],"description":"If this is set for a project series or a record it implies that the data has been modified in some way and so the file_data must be stored."},{"parameter":"chronology","label":"Chronology","type":"Text","units":"","options":[],"description":"The chronology used for a data series."},{"parameter":"code","label":"Code","type":"Pre","units":"","description":"The text of model code used for analysis.","options":[]},{"parameter":"cold","label":"Cold","type":"Boolean","units":"","description":"Whether a chronological period is flagged as cold or not.  If flagged as cold and warm it is a transition.","options":[]},{"parameter":"collected","label":"Collected","type":"Date","units":"","options":[],"description":"Date of collection"},{"parameter":"collected_by","label":"By","type":"Text","units":"","options":[],"description":"person responsible for collecting sample"},{"parameter":"color","label":"Color","type":"Color","units":"","description":"A color to be used in data display.","options":[]},{"parameter":"combines","label":"Combines","type":"Text","units":"","description":"Used in dendrochronological projects - the records combined together to make this one.","options":[]},{"parameter":"combine_c","label":"C_C","type":"Number","units":"","description":"The correlation between the combined records in dendrochronological projects.","options":[]},{"parameter":"combine_n","label":"N_C","type":"Number","units":"","description":"The overlap between the combined records in dendrochronological projects.","options":[]},{"parameter":"combine_p","label":"P_C","type":"Number","units":"","description":"The probability for combined records in dendrochronological projects.","options":[]},{"parameter":"combine_t","label":"T_C","type":"Number","units":"","description":"The T-statistic for combined records in dendrochronological projects.","options":[]},{"parameter":"compilation","label":"Compilation","type":"Object","units":"","options":[],"description":"A JSON object which contains information about a data compilation."},{"parameter":"context","label":"Context","type":"Text","units":"","options":[],"description":"Context of a sample within a site/record"},{"parameter":"country","label":"Country","type":"Text","units":"","description":"The official country name or blank if marine or not located.","options":[]},{"parameter":"d13C","label":"δ^{13}C","type":"Number","units":"‰","description":"The carbon ^{13}C/^{12}C stable isotope ratio expressed in in parts per thousand (per mil, ‰) against the Pee Dee Belemnite (PDB) standard.","options":[]},{"parameter":"D14C","label":"D^{14}C","type":"Number","units":"‰","options":[],"description":"Measure of radiocarbon content."},{"parameter":"d15N","label":"δ^{15}N","type":"Number","units":"‰","options":[],"description":"The nitrogen ^{15}N/^{14}N stable isotope ratio expressed in in parts per thousand (per mil, ‰) against the atmospheric ratio."},{"parameter":"d18O","label":"δ^{18}O","type":"Number","units":"‰","options":[],"description":"The oxygen ^{18}O/^{16}O stable isotope ratio expressed in in parts per thousand (per mil, ‰) Vienna Standard Mean Ocean Water (VSMOW)"},{"parameter":"data","label":"Data","type":"TextArea","units":"","description":"This is a data object where each attribute is a parameter name which refers to an array or parameter values.","options":[]},{"parameter":"data_url","label":"Data URL","type":"Text","units":"","options":[],"description":"This gives the URL where the data is stored or from which it was retrieved."},{"parameter":"date","label":"Date","type":"Number","units":"years","description":"This is the result of a scientific date determination, typically given in the form of an age relative to some specific time point.","options":[]},{"parameter":"dated","label":"Dated","type":"Boolean","units":"","description":"Whether a sample is dated or not (typically used in dendrochronological projects.","options":[]},{"parameter":"dated_against","label":"Dated against","type":"Text","units":"","description":"Which master chronology has be used to date this sample.","options":[]},{"parameter":"dated_c","label":"C_D","type":"Number","units":"","description":"The correlation between this sample and the master chronology in dendrochronological projects.","options":[]},{"parameter":"dated_n","label":"N_D","type":"Number","units":"","description":"The overlap between this sample and the master chronology in dendrochronological projects.","options":[]},{"parameter":"dated_p","label":"P_D","type":"Number","units":"","description":"The probability for the dating of this sample against a master chronology in dendrochronological projects.","options":[]},{"parameter":"dated_t","label":"T_D","type":"Number","units":"","description":"The T-statistic for the dating of this sample against a master chronology in dendrochronological projects.","options":[]},{"parameter":"date_datum","label":"Date datum","type":"Number","units":"year (astronomical)","description":"The datum for a date parameter which is typically either the measurement year or in the case of dates relative to mid 1950 a value of 1950.5.","options":[]},{"parameter":"date_type","label":"Date type","type":"Text","options":["C14","Ar","OSL","UTh","Years"],"units":"","description":"This is the type of scientific dating technique used for determining the date parameter."},{"parameter":"default_value","label":"Default","type":"Text","units":"","options":[],"description":"The default value for a parameter which cannot be null."},{"parameter":"Delta14C","label":"Δ^{14}C","type":"Number","units":"‰","options":[],"description":"Δ14C for radiocarbon measurements."},{"parameter":"delta_r","label":"ΔR","type":"Number","units":"14C years","description":"For radiocarbon analysis this is an assessment of the effective reservoir offset.  It should normally be given together with delta_r_sigma as a numeric value; for example delta_r:80, delta_r_sigma:30.\nFor backward compatibility with earlier version a single text version can be used; this would usually be a normal distribution in the form N(80,30) where 80 is the mean estimate of the of offset and 30 is the uncertainty.","options":[]},{"parameter":"dest_record","label":"t' record","type":"Text","options":["Ar","DendroSH","DendroNH","GICC05","IntCal04","IntCal09","IntCal13","IntCal20","Marine04","Marine09","Marine13","Marine20","OSL","SHCal04","SHCal13","SHCal20","UTh","Years"],"units":"","description":"In a time-transfer function, the name of the destination timescale t'."},{"parameter":"dir","label":"Directory","type":"Boolean","units":"","options":[],"description":"Defines whether the name in a file list is a directory or not."},{"parameter":"distance","label":"Distance","type":"Number","units":"km","options":[],"description":"Distance between sites"},{"parameter":"dp","label":"DP","type":"Number","units":"","options":[],"description":"The number of decimal points a numeric parameter is set to.  This can be set to \"NaN\" or \"\" for no constraint, 0 for integer values, positive values for fractional values and negative values for rounding.  1234.5678 will show as 1234.57 if dp is set to 2, 1235 if dp is set to 0, 1200 if dp is set to -2 and 1234.5678 if dp is set to \"NaN\"."},{"parameter":"elevation","label":"Elevation (m)","type":"Number","units":"m","description":"The elevation of the site above mean sea level.","options":[]},{"parameter":"email","label":"Email","type":"Text","units":"","description":"An email address.","options":[]},{"parameter":"environment","label":"Environment","type":"Text","units":"","description":"The environment descriptor for a site or sample.","options":[]},{"parameter":"error","label":"±1σ","type":"Number","units":"","description":"A generic standard uncertainty.","options":[]},{"parameter":"eruption","label":"Eruption","type":"Text","units":"","description":"The name of a specific volcanic eruption.","options":[]},{"parameter":"eruption_type","label":"Type","type":"Text","units":"","options":["Dome","Fissure","Hawaiian","Maar","Phreato-Plinian","Plinian","Strombolian","Sub-Plinian","Ultra-Plinian"],"description":"Type of volcanic eruption"},{"parameter":"event","label":"Event","type":"Text","units":"","description":"The name of an event within an event stratigraphy.","options":[]},{"parameter":"F14C","label":"F^{14}C","type":"Number","units":"","description":"The F^{14}C value associated with a radiocarbon measurement.","options":[]},{"parameter":"feeding","label":"Feeding","type":"Text","units":"","options":[],"description":"Feeding habits of taxa."},{"parameter":"file","label":"File","type":"Text","units":"","description":"The url of the file where the data is stored.","options":[]},{"parameter":"filename","label":"Name","type":"Text","units":"","description":"The name of a file in a directory.","options":[]},{"parameter":"filesize","label":"Size","type":"Number","units":"","description":"The size of a file in a directory.","options":[]},{"parameter":"filtered","label":"Filtered","type":"Boolean","units":"","description":"Used in dendrochronological projects to denote whether this dataset has already been filtered.","options":[]},{"parameter":"fraction","label":"Fraction","type":"Text","units":"","options":[],"description":"The fraction of a sample which was dated (for example collagen from material bone)."},{"parameter":"header_list","label":"Headers","type":"Text","units":"","description":"A comma separated list of parameters in a data series header.  This allows the series header to include extra parameters not set for the type.  These should be described in the parameters array for the project if they are not within the main schema.","options":[]},{"parameter":"height","label":"Height","type":"Number","units":"","options":[],"description":"Height of image or other object in l_units (default is m in most contexts or mm for Dendro applications)"},{"parameter":"IGSN","label":"IGSN","type":"Text","units":"","options":[],"description":"International Generic Sample Number.  The IGSN can be used as the sample name but, if not, a table of sample names and associated IGSN numbers can be added to each record as an IGSN_Index to resolve the samples to their IGSN."},{"parameter":"instrument","label":"Instrument","type":"Text","units":"","options":[],"description":"Instrument used in analysis"},{"parameter":"intcal_cor_matrix","label":"Correlation","type":"TextArea","units":"","options":[],"description":"Tab delimited text matrix for use with intcal calibration curve construction."},{"parameter":"intcal_data_id","label":"Id","type":"Number","units":"","description":"This is the unique ID for a sample included in the IntCal dataset.","options":[]},{"parameter":"intcal_division","label":"Division","type":"Number","units":"","description":"This is the sub-division of the IntCal set.","options":[]},{"parameter":"intcal_reservoir","label":"Reservoir","type":"Number","units":"14C years","description":"This is the reservoir offset for this sample against the atmosphere in and IntCal dataset.","options":[]},{"parameter":"intcal_seq_no","label":"Seq","type":"Number","units":"","description":"The is the sequence number used in some IntCal datasets.","options":[]},{"parameter":"intcal_set","label":"Set","type":"Number","units":"","description":"This is the IntCal set number for this series.","options":[]},{"parameter":"intcal_set_type","label":"Type","type":"Text","units":"","description":"This defines the IntCal set type.","options":["Compare","Extra","Int","NewInt","NewSH","NH1","NH2","NH3","SH","SH1-2","SH3"]},{"parameter":"invert","label":"Invert","type":"Boolean","units":"","options":[],"description":"If set to true then plots will normally show values from high to low rather than the normal low to high."},{"parameter":"json_application","label":"JSON application","type":"Text","units":"","options":[],"description":"This defines the application which a JSON object is intended to be used with.  For IntChron this should be set to IINTCHRON.Project, INTCHRON.Series or INTCHRON.Record.  The value can be followed by a colon and then a version number."},{"parameter":"labcode","label":"Lab code","type":"Text","units":"","description":"The unique labcode associated with a date measurement.","options":[]},{"parameter":"label","label":"Label","type":"Text","units":"","options":[],"description":"The label used to display a parameter within applications.  This can include LaTeX style superscripts and subscripts."},{"parameter":"latitude","label":"Lat","type":"Number","units":"°","description":"The latitude in decimal degrees.","options":[]},{"parameter":"longitude","label":"Long","type":"Number","units":"°","description":"The longitude in decimal degrees.","options":[]},{"parameter":"l_units","label":"L units","type":"Text","units":"","options":["geo","m","mm","um","nm"],"description":"This parameter is used to define how lengths are defined in a specific context.  The default 'geo' option implies that x,y,z are stored in m with the display of z being set using z_units.  If l_units is set to anything other than 'geo' this value will take precedence and the values are stored in the specified units.  The meaning of width and height are set using this.  For Dendro work the assumed unit is mm as used in ring_width."},{"parameter":"material","label":"Material","type":"Text","units":"","description":"The material of the sample referred to in the data series.","options":[]},{"parameter":"measurement_year","label":"Year measured","type":"Number","units":"years (calendar)","description":"The year when the measurements were made.","options":[]},{"parameter":"model_type","label":"Model type","type":"Text","options":["OxCal","Dendro"],"units":"","description":"The type of chronological model used."},{"parameter":"name","label":"Name","type":"Text","units":"","description":"The name of a project or similar.","options":[]},{"parameter":"noaa_ncei_study","label":"Study","type":"Number","units":"","options":[],"description":"NOAA NCEI study number"},{"parameter":"notes","label":"Notes","type":"TextArea","units":"","description":"Extended notes.","options":[]},{"parameter":"ok","label":"Ok","type":"Boolean","units":"","options":[],"description":"Status flag which shows if data should be used or not.  This can be used to include all data including data which does not pass quality criteria."},{"parameter":"ondemand","label":"Load on demand","type":"Boolean","units":"","description":"This is a project option and defines whether you should wait to download linked data until needed.  This is appropriate for very extended datasets.","options":[]},{"parameter":"options","label":"Options","type":"Array","units":"","options":[],"description":"An array of possible values for a parameter."},{"parameter":"orcid","label":"ORCID","type":"Text","units":"","options":[],"description":"The ORCID of a person responsible for a publication or a data compilation"},{"parameter":"parameter","label":"Parameter","type":"Text","units":"","options":[],"description":"The variable name for a parameter within the data model.  This should be a valid javascript variable name."},{"parameter":"parameters","label":"Parameters","type":"Array","units":"","options":[],"description":"An array of parameter descriptors within the project object."},{"parameter":"parameter_list","label":"Parameters","type":"Text","units":"","description":"A comma separated list of parameters in a data series.  This allows the series to include extra parameters not set for the type.  These should be described in the parameters array for the project if they are not within the main schema.","options":[]},{"parameter":"path","label":"Directory path","type":"Text","units":"","description":"The directory path.","options":[]},{"parameter":"project_series_type","label":"Series type","type":"Text","options":["Data","Dendro_Master","Eruptions","Events","Files","IntCal_Curve","IntCal_Curve_B","Maps","Model","NOAA_NCEI_Study","Periods","Plans","Relationship","R_Datelist","Sample_Dataset","Tephra_Sample_Majors","Tephra_Sample_Trace"],"units":"","description":"The type of project level data series."},{"parameter":"qual","label":" ","type":"Text","options":["",">","m"],"units":"","description":"The qualifier associated with a radiocarbon date. '>' indicates that the date is greater than. 'm' indicates that the date is modern and only has an associated F^{14}C value."},{"parameter":"reconstruction","label":"Reconstruction","type":"Text","units":"","description":"The type of reconstruction used to convert proxy data to climate variables.","options":[]},{"parameter":"record","label":"Record","type":"Text","units":"","description":"The name of a specific record.  This should be the formal record identifier if this is available.","options":[]},{"parameter":"record_comment","label":"Notes","type":"TextArea","units":"","description":"Extended comments on the record.","options":[]},{"parameter":"ref","label":"Reference","type":"Text","units":"","description":"This is a specific reference either in terms of the doi or the reference identifier depending on the prefix.  The first four letters should either be \"doi:\" or \"ref:\" followed by the doi or unique reference (as specified in the bibliography).","options":[]},{"parameter":"refs","label":"References","type":"Array","units":"","description":"This is an array of reference values.  Each element of the array is formatted as in the ref parameter above.","options":[]},{"parameter":"region","label":"Region","type":"Text","units":"","description":"The region of a site, depending on local conventions.","options":[]},{"parameter":"reservoir","label":"Reservoir","type":"Number","units":"14C years","options":[],"description":"Radiocarbon offset relative to the atmosphere."},{"parameter":"retrieved","label":"Retrieved","type":"Date","units":"","options":[],"description":"The date when the data was retrieved from the data source."},{"parameter":"ring_count","label":"Ring count","type":"Number","units":"","description":"The total ring count for a dendrochronological series.","options":[]},{"parameter":"ring_segment","label":"Seg.","type":"Text","units":"","options":[],"description":"Ring segment measured for isotopes, radiocarbon etc.  Normally EW, LW or subdivisions EW1, EW2, LW1, LW2 or some combinations such as EW/LW.  If omitted or blank it is usual to assume EW/LW for radiocarbon or LW for isotopes."},{"parameter":"ring_width","label":"Ring width","type":"Number","units":"mm","description":"The ring width for a dendrochronological sample.","options":[]},{"parameter":"r_date","label":"R_Date","type":"Number","units":"14C years","description":"The mean radiocarbon date associated with a radiocarbon measurement.","options":[]},{"parameter":"r_date_sigma_batch","label":"±1σ_{B}","type":"Number","units":"","options":[],"description":"The batch uncertainty included within radiocarbon measurements.  Normally common to all samples in a batch."},{"parameter":"r_date_sigma_extra","label":"±1σ_{+}","type":"Number","units":"14C years","description":"The extra uncertainty associated with a radiocarbon measurement.","options":[]},{"parameter":"r_date_sigma_mult","label":"±1σ_{x}","type":"Number","units":"","description":"An error multiplier to be applied to radiocarbon measurements.","options":[]},{"parameter":"sample","label":"Sample","type":"Text","units":"","description":"The sample reference identifier.","options":[]},{"parameter":"sample_depth","label":"Sample depth","type":"Number","units":"","description":"In a dendrochronological series the number of distinct samples represented.","options":[]},{"parameter":"sapwood","label":"Sapwood","type":"Number","units":"","description":"The number of sapwood rings present.  The value can also be used to define the presence of the H/S boundary and bark edge.  A value of 0 implies no H/S boundary.  A value between 0 and 1 implies the H/S boundary is present but no whole sapwood rings.  Any integer number of 1 or higher indicates the number of whole sapwood rings present.  A fractional value above 1 indicates bark edge: < n.2 is Winter felled, otherwise if < n.5 is Spring felled and anything higher is Summer felled.  Typical values are 0 (none), 0.1 (H/S), 12 (no bark), 20.1 (Winter felled), 20.25 (Spring felled), 20.5 (Summer felled).","options":[]},{"parameter":"schema","label":"Schema","type":"Text","units":"","options":[],"description":"A reference to the naming schema for the object concerned.  This should normally reference this document."},{"parameter":"sector","label":"Sector","type":"Text","units":"","options":[],"description":"Sector of record or site"},{"parameter":"sed","label":"Sedimentation rate","type":"Number","units":"m/year","description":"The sedimentation rate in m/year.","options":[]},{"parameter":"selected","label":"Selected","type":"Boolean","units":"","options":[],"description":"Defines whether a series or a record is selected for analysis within a project."},{"parameter":"series","label":"Series","type":"Text","units":"","description":"The name of a particular data series.","options":[]},{"parameter":"series_comment","label":"Notes","type":"TextArea","units":"","description":"The comment on a data-series.","options":[]},{"parameter":"series_sample","label":"Sample","type":"Text","units":"","options":[],"description":"The sample for a whole series of measurement for example a tree ring series.  This can be used where the series name needs to be used for other purposes."},{"parameter":"series_type","label":"Series type","type":"Text","options":["AgeDepth","Data","Dates","Dendro_Cores","Dendro_Sample","Files","IGSN_Index","IntCal_Correlation","IntCal_Data","IntCal_Data_B","Maps","Model","MRDB_Data","NOAA_NCEI_Study","Plans","Proxies","R_Datelist","R_Dates","Sample_Data","SubSample_Data","SubSample_Images","Tephras","Tephra_Distribution","Tephra_Samples","Tephra_Sample_Majors","Tephra_Sample_Trace","Volc_Eruptions"],"units":"","description":"The type of a data series within a record."},{"parameter":"site","label":"Site","type":"Text","units":"","description":"The name of the site (this should be unique to the country).","options":[]},{"parameter":"site_type","label":"Site type","type":"Text","options":["Archaeological","Atmospheric","Dendrochronological","Ice","Marine","Speleothem","Terrestrial","Volcano"],"option_colors":["rgb(200,0,0)","rgb(0,208,219)","rgb(11,93,224)","rgb(20,168,0)","rgb(128,128,128)","rgb(181,93,45)","rgb(245,143,0)"],"units":"","description":"The category of record and site."},{"parameter":"source_record","label":"t record","type":"Text","options":["Ar","DendroSH","DendroNH","GICC05","IntCal04","IntCal09","IntCal13","IntCal20","Marine04","Marine09","Marine13","Marine20","OSL","SHCal04","SHCal13","SHCal20","UTh","Years"],"units":"","description":"For a time transfer function this gives the source timescale t."},{"parameter":"species","label":"Species","type":"Text","units":"","description":"The species of the sample in the data record.  Ideally formal latin species names or broader taxonimoc  classification should be used.  This term was used in version 3 of some standard lists but has now been replaced with taxon for broader usage.  The integration tool will update species to taxon.","options":[]},{"parameter":"suppress_t","label":"Suppress t","type":"Boolean","units":"","description":"This flag is set for records where the time scale should be suppressed in analysis.","options":[]},{"parameter":"suppress_z","label":"Suppress z","type":"Boolean","units":"","description":"This flag is set for records where the depth scale should be suppressed in analysis, for example where there is no associated depth.","options":[]},{"parameter":"t","label":"Date","type":"Number","units":"years (astronomical)","description":"The time for an event, as inferred from dating or modelling.  This is expressed in fractional astronomical years, where for example 1950.5 is the middle of the year 1950.","options":[]},{"parameter":"taxon","label":"Taxon","type":"Text","units":"","options":[],"description":"A taxonomic description which is ideally at genus or species level depending on how specific it is possible to be."},{"parameter":"taxon_class","label":"Class","type":"Text","units":"","options":[],"description":"A classification of taxa for particular applications."},{"parameter":"tephra_deposit","label":"Deposit","type":"Text","units":"","options":["air fall","block and ash flow","fall","flow","fluvial","ignimbrite","interbedded fall and flow","interbedded falls and surges","lag breccia","remobilised","surge","surges"],"description":"Mode of tephra deposition."},{"parameter":"tephra_majors","label":"Majors","type":"Array","units":"%","options":["SiO2","TiO2","Al2O3","FeOt","MnO","MgO","CaO","Na2O","K2O","P2O5","Cl","F","total"],"description":"The major element components measured in tephra glass analyses."},{"parameter":"tephra_shards","label":"Shards","type":"Number","units":"/g","options":[],"description":"Number of tephra shards counted in sample normally per g unless tephra_shards_abs is set."},{"parameter":"tephra_shards_abs","label":"Abs","type":"Boolean","units":"","options":[],"description":"Set if the tephra shard count is absolute."},{"parameter":"tephra_trace","label":"Trace","type":"Array","units":"ppm","options":["Ca","Sc","Ti","V","Fe","Ni","Rb","Sr","Y","Zr","Nb","Ba","La","Ce","Pr","Nd","Sm","Eu","Gd","Dy","Er","Yb","Lu","Hf","Ta","Pb","Th","U"],"description":"The trace element components measured in tephra glass analyses."},{"parameter":"tephra_type","label":"Type","type":"Text","units":"","options":["distal","mid-distal","proximal"],"description":"Type of tephra deposit."},{"parameter":"type","label":"Type","type":"Text","units":"","options":["Boolean","Number","Text"],"description":"The type of a parameter."},{"parameter":"t_autorange","label":"Auto","type":"Boolean","units":"","description":"A flag which sets wether the project automatically sets the time range of interest to include the full time range of all records.","options":[]},{"parameter":"t_dash","label":"t'","type":"Number","units":"years (astronomical)","description":"In a time transfer function, this defines the time in the target (t') time scale in fractional astronomical years.","options":[]},{"parameter":"t_from","label":"From","type":"Number","units":"years (astronomical)","description":"For a project this defines the start time for any analysis or plotting.","options":[]},{"parameter":"t_median","label":"t^{~}","type":"Number","units":"","description":"The median t value","options":[]},{"parameter":"t_schulman","label":"Schulman","type":"Boolean","units":"","options":[],"description":"Displays the date in which growth started as used in dendrochronology. If this is not set the midpoint of the growth period will be shown which in the SH is the start of the following year.  This does not affect the display of NH tree ring dates which should be defined as the middle of the year."},{"parameter":"t_sigma","label":"±1σ","type":"Number","units":"","description":"The one sigma uncertainty in t","options":[]},{"parameter":"t_source","label":"Timescale","type":"Text","options":["Ar","ArAr","Calendar","DendroNH","DendroSH","GICC05","IntCal04","IntCal09","IntCal13","IntCal20","Marine04","Marine09","Marine13","Marine20","Orbital","OSL","SHCal04","SHCal13","SHCal20","UTh","Varve","Years"],"units":"","description":"For a record this defines which timescale has been used (primarily) to define the chronology."},{"parameter":"t_to","label":"To","type":"Number","units":"years (astronomical)","description":"For a project this defines the end time for any analysis or plotting.","options":[]},{"parameter":"t_to_orig","label":"To (orig.)","type":"Number","units":"","description":"For a dendrochronological sample, the original date for the final ring.  This can be used to reset a ring sequence to the original chronological position if it is changed during analysis.","options":[]},{"parameter":"t_units","label":"Time units","type":"Text","options":["±CE","calBP","b2k","AD","BC","CE","BCE"],"units":"","description":"This defines the preferred units for display or plotting of time scales.  It does NOT define the units for the stored data which is always fractional astronomical years."},{"parameter":"units","label":"Units","type":"Text","units":"","options":[],"description":"The units for a parameter."},{"parameter":"updated","label":"Updated","type":"Date","units":"","description":"The date when the data compilation was made or last updated.","options":[]},{"parameter":"url","label":"URL","type":"Text","units":"","options":[],"description":"A link to an online resource (such as a database, website or page)."},{"parameter":"volcano","label":"Volcano","type":"Text","units":"","description":"The volcanic center associated with an eruption or tephra layer.","options":[]},{"parameter":"volc_region","label":"Region","type":"Text","units":"","options":[],"description":"Volcanic region from which a tephra derives"},{"parameter":"warm","label":"Warm","type":"Boolean","units":"","description":"Whether a chronological period is flagged as warm or not.  If flagged as cold and warm it is a transition.","options":[]},{"parameter":"width","label":"Width","type":"Number","units":"","options":[],"description":"Width of image or other object in l_units (default is m in most contexts or mm for Dendro applications)"},{"parameter":"x","label":"E (m)","type":"Number","units":"m","options":[],"description":"Easting from location unless l_units is set to redefine."},{"parameter":"x_range","label":"↔","type":"Number","units":"m","options":[],"description":"The range of a sample or plan in the x direction (normally East)"},{"parameter":"y","label":"N (m)","type":"Number","units":"m","options":[],"description":"Northing from location unless l_units is set to redefine."},{"parameter":"y_range","label":"↕","type":"Number","units":"m","options":[],"description":"The range of a sample or plan in the y direction (normally North)"},{"parameter":"z","label":"Depth","type":"Number","units":"m","description":"Depth (or optionally height) within a record.  See also z_type.  This is normally stored in m  but can be displayed in other units.  This defines the central depth (see also z_range).  This parameter is mostly intended for use as proxy for time in age-depth models.","options":[]},{"parameter":"z_basis","label":"z basis","type":"Text","options":["original","composite","event-free"],"units":"","description":"This defines whether the depth is an original physical depth or based on a composite or event-free scale."},{"parameter":"z_range","label":"z range","type":"Number","units":"m","description":"For any specific sample the range in depth over which the sample came.  The z value specifies the central value.","options":[]},{"parameter":"z_style","label":"z style","type":"Text","options":["z,z_range","z_from-z_to","z±dz"],"units":"","description":"The formal used for presenting depth or ring information."},{"parameter":"z_type","label":"z type","type":"Text","options":["depth","height","layers","rings","time"],"units":"","description":"This specifies for a record whether the z value is a height, depth or some other measure."},{"parameter":"z_units","label":"z units","type":"Text","options":["","m","cm","mm","layers","rings","length"],"units":"","description":"The preferred units for the display of the z parameter.  This does NOT affect the stored value which (in the case of depth or height) is always m.  If this is set to 'length' then the units are as defined by l_units and then the  storage is in the defined unit rather than in m."}],"seriesHeaders":[{"type":"AgeDepth","parameters":["t_source","notes"]},{"type":"Data","parameters":["notes"]},{"type":"Dates","parameters":["date_type","date_datum"]},{"type":"Dendro_Cores","parameters":["path"]},{"type":"Dendro_Master","parameters":["site","region","country","longitude","latitude","t_source","t_from","t_to","ring_count","filtered","notes"]},{"type":"Dendro_Sample","parameters":["t_from","t_to","t_to_orig","ring_count","sapwood","filtered","dated","dated_against","dated_t","dated_c","dated_p","dated_n","combines","combine_t","combine_c","combine_p","combine_n","notes"]},{"type":"Eruptions","parameters":[]},{"type":"Events","parameters":[]},{"type":"Files","parameters":["path"]},{"type":"IGSN_Index","parameters":[]},{"type":"IntCal_Correlation","parameters":["intcal_set_type","intcal_set","intcal_division","intcal_cor_matrix"]},{"type":"IntCal_Curve","parameters":["site_type","intcal_set_type"]},{"type":"IntCal_Curve_B","parameters":["site_type","intcal_set_type"]},{"type":"IntCal_Data","parameters":["intcal_set_type","intcal_set","intcal_division","series_sample","chronology","notes"]},{"type":"IntCal_Dataset","parameters":[]},{"type":"IntCal_Data_B","parameters":["intcal_set_type","notes","material"]},{"type":"Maps","parameters":["path"]},{"type":"Model","parameters":["model_type","file","notes","code"]},{"type":"MRDB_Data","parameters":[]},{"type":"NOAA_NCEI_Study","parameters":["noaa_ncei_study"]},{"type":"Periods","parameters":[]},{"type":"Plans","parameters":["path"]},{"type":"Proxies","parameters":["reconstruction","notes"]},{"type":"Records","parameters":[]},{"type":"Relationship","parameters":["dest_record","source_record"]},{"type":"R_Datelist","parameters":[]},{"type":"R_Dates","parameters":[]},{"type":"Sample_Data","parameters":[]},{"type":"Sample_Dataset","parameters":[]},{"type":"SubSample_Data","parameters":["series_sample","l_units"]},{"type":"SubSample_Images","parameters":["l_units"]},{"type":"Tephras","parameters":[]},{"type":"Tephra_Distribution","parameters":["eruption"]},{"type":"Tephra_Samples","parameters":[]},{"type":"Tephra_Sample_Majors","parameters":["z","z_range","sample","context","sector","tephra_type","tephra_deposit","material","collected","collected_by","volc_region","volcano","eruption","notes"]},{"type":"Tephra_Sample_Trace","parameters":["z","z_range","sample","context","sector","tephra_type","tephra_deposit","material","collected","collected_by","volc_region","volcano","eruption","notes"]},{"type":"Volc_Eruptions","parameters":[]}],"seriesParameters":[{"type":"AgeDepth","parameters":["z","t","t_sigma"]},{"type":"Data","parameters":[]},{"type":"Dates","parameters":["z","z_range","t","t_sigma","labcode","sample","material","taxon","date","date_sigma"]},{"type":"Dendro_Cores","parameters":["filename","filesize","updated","dir","series_sample","width","height","data"]},{"type":"Dendro_Master","parameters":["z","t","ring_width","sample_depth"]},{"type":"Dendro_Sample","parameters":["z","t","ring_width","sample_depth"]},{"type":"Eruptions","parameters":["volcano","eruption","eruption_type","t","t_sigma","t_source","ref","notes"]},{"type":"Events","parameters":["event","t","t_sigma","t_source","warm","cold"]},{"type":"Files","parameters":["filename","filesize","updated","dir"]},{"type":"IGSN_Index","parameters":["IGSN","sample"]},{"type":"IntCal_Correlation","parameters":[]},{"type":"IntCal_Curve","parameters":["t","r_date","r_date_sigma"]},{"type":"IntCal_Curve_B","parameters":["t","F14C","F14C_sigma","Delta14C","Delta14C_sigma"]},{"type":"IntCal_Data","parameters":["z","z_range","t","t_sigma","intcal_data_id","intcal_seq_no","sample","ring_segment","calage","calage_range","calage_sigmaI","calage_sigmaD","calage_sigmaC","labcode","batch","r_date","r_date_sigma","r_date_sigma_extra","r_date_sigma_batch","r_date_sigma_mult","intcal_reservoir","intcal_reservoir_sigma"]},{"type":"IntCal_Dataset","parameters":["record","series","intcal_set_type","intcal_set","intcal_division","z","z_range","t","t_sigma","intcal_data_id","intcal_seq_no","sample","ring_segment","calage","calage_range","calage_sigmaI","calage_sigmaD","calage_sigmaC","labcode","batch","r_date","r_date_sigma","r_date_sigma_extra","r_date_sigma_batch","r_date_sigma_mult","intcal_reservoir","intcal_reservoir_sigma"]},{"type":"IntCal_Data_B","parameters":["t","calage_range","sample","ring_segment","labcode","F14C","F14C_sigma","Delta14C","Delta14C_sigma","batch"]},{"type":"Maps","parameters":["filename","filesize","updated","dir","longitude","longitude_range","latitude","latitude_range"]},{"type":"Model","parameters":[]},{"type":"MRDB_Data","parameters":["t","sample","labcode","r_date","r_date_sigma","d13C","delta_r","delta_r_sigma","reservoir","reservoir_sigma","taxon","taxon_class","feeding","ref","notes"]},{"type":"NOAA_NCEI_Study","parameters":[]},{"type":"Periods","parameters":["event","t","t_sigma","t_source","warm","cold"]},{"type":"Plans","parameters":["filename","filesize","updated","dir","x","x_range","y","y_range","z","z_range"]},{"type":"Proxies","parameters":["z","z_range","t","t_sigma"]},{"type":"Records","parameters":["record","site","region","country","longitude","latitude","elevation","environment","site_type"]},{"type":"Relationship","parameters":["t_dash","t","t_sigma"]},{"type":"R_Datelist","parameters":["t","t_sigma","labcode","site","region","country","longitude","latitude","sample","material","taxon","qual","r_date","r_date_sigma","F14C","F14C_sigma","d13C"]},{"type":"R_Dates","parameters":["z","z_range","t","t_sigma","labcode","sample","qual","r_date","r_date_sigma","material","taxon","d13C"]},{"type":"Sample_Data","parameters":["z","z_range","labcode","sample","material","taxon"]},{"type":"Sample_Dataset","parameters":["labcode","site","region","country","longitude","latitude","sample","material","taxon"]},{"type":"SubSample_Data","parameters":["x","y"]},{"type":"SubSample_Images","parameters":["filename","filesize","updated","dir","series_sample","x","y","width","height"]},{"type":"Tephras","parameters":["z","z_range","t","t_sigma","sample","volc_region","volcano","eruption","ref"]},{"type":"Tephra_Distribution","parameters":["site","country","longitude","latitude","elevation","site_type","sample","tephra_type","tephra_deposit","material","z_range","collected","collected_by","notes"]},{"type":"Tephra_Samples","parameters":["z","z_range","sample","t","t_sigma","context","sector","tephra_type","tephra_deposit","material","tephra_shards","tephra_shards_abs","volc_region","volcano","eruption","notes"]},{"type":"Tephra_Sample_Majors","parameters":["labcode","batch","instrument","tephra_majors","ok"]},{"type":"Tephra_Sample_Trace","parameters":["labcode","batch","instrument","tephra_trace","ok"]},{"type":"Volc_Eruptions","parameters":["eruption","eruption_type","t","t_sigma","t_source","ref","notes"]}]};